﻿SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- First we add two new fields to table Response
-- US1685 - RHL - November 2013
-- =============================================
IF NOT EXISTS(SELECT * FROM sys.columns WHERE Name = N'QuestionOrder' AND object_id = OBJECT_ID(N'Response'))
ALTER TABLE [dbo].[Response]  ADD  QuestionOrder [int] NULL

IF NOT EXISTS(SELECT * FROM sys.columns WHERE Name = N'ChoiceOrder' AND object_id = OBJECT_ID(N'Response'))
ALTER TABLE [dbo].[Response] ADD  ChoiceOrder [int] NULL

-- =============================================
-- Then we gotta update correspondent stored procedures Sp_UpdateRespondentResponse used by DTS Export
-- Sp_UpdateRespondentResponse now uses MERGE for SQL 2008 and above (US1682 May 2013)
-- US1685 - RHL - November 2013
-- =============================================
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[Sp_UpdateRespondentResponse]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[Sp_UpdateRespondentResponse]
GO

DECLARE @version varchar(128), @majorversion int
SET @version = CAST(SERVERPROPERTY('productversion') as varchar(128))
SET @majorversion = SUBSTRING(@version,1,CHARINDEX('.',@version,0)-1)
IF @majorversion >= 10 AND NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[Sp_UpdateRespondentResponse]') AND type in (N'P', N'PC'))
	BEGIN
		--MERGE is only supported on SQL2008 and above
		EXEC dbo.sp_executesql @statement = N'		
		CREATE PROCEDURE [dbo].[Sp_UpdateRespondentResponse]
		 @ProjectId     INT,
		 @UserId        INT,
		 @CollectMode   INT,
		 @RpsRespondent VARCHAR(10),
		 @RpsQuestion   VARCHAR(32),
		 @RpsMatrix     BIGINT,
		 @RpsMention    INT,
		 @RpsContent    NVARCHAR(100),
		 @rpsOpened     NTEXT,
		 @rpsType       INT,
		 @CallId        INT,
		 @Source        nvarchar(max),
		 @Modified      datetime = null,
		 @QuestionOrder INT = null,
		 @ChoiceOrder   INT = null
		AS

		 IF @Modified is null SET @Modified = GETUTCDATE();
		 
		 MERGE Response as target
		 USING (SELECT @RpsRespondent, @RpsQuestion, @RpsMatrix, @RpsMention, @rpsType, -- PK
				@ProjectId, @UserId, @CollectMode, @RpsContent, @rpsOpened,  @CallId, @Source, @Modified, @QuestionOrder, @ChoiceOrder) --Update field
			as source (Respondent, Question, Matrix, Mention, [Type],
				ProjectId, UserId, CollectMode, Content, Opened, CallId, [Source], Modified, QuestionOrder, ChoiceOrder)
		 ON (RpsRespondent = source.Respondent 
			and RpsQuestion = source.Question 
			and RpsMatrix = source.Matrix 
			and RpsMention = source.Mention 
			and RpsType = source.[Type])
		 WHEN MATCHED THEN
			UPDATE SET ProjectId = source.ProjectId,
				 CollectMode = CASE WHEN source.CollectMode < 0 THEN target.CollectMode ELSE source.CollectMode END,
				 ModifiedBy = source.UserId,
				 Modified = source.Modified,
				 RpsContent = source.Content,
				 RpsOpened = source.Opened,
				 CallId = source.CallId,
				 [Source] = source.[Source],
				 QuestionOrder = source.QuestionOrder,
				 ChoiceOrder = source.ChoiceOrder
		 WHEN NOT MATCHED THEN
			INSERT (RpsRespondent, RpsQuestion, RpsMatrix, RpsMention, RpsType,
				 ProjectId, CollectMode, ModifiedBy, Modified, RpsContent, RpsOpened, CallId, [Source], QuestionOrder, ChoiceOrder)
			VALUES (Respondent, Question, Matrix, Mention, [Type],
				 ProjectId, CollectMode, UserId, Modified, Content, Opened, CallId, [Source], QuestionOrder, ChoiceOrder);
		'
	END
ELSE
	BEGIN
		--We are still using UPDATE for SQL2005 and below
		EXEC dbo.sp_executesql @statement = N'
		CREATE PROCEDURE [dbo].[Sp_UpdateRespondentResponse]
		 @ProjectId     INT,
		 @UserId        INT,
		 @CollectMode   INT,
		 @RpsRespondent VARCHAR(10),
		 @RpsQuestion   VARCHAR(32),
		 @RpsMatrix     BIGINT,
		 @RpsMention    INT,
		 @RpsContent    NVARCHAR(100),
		 @rpsOpened     NTEXT,
		 @rpsType       INT,
		 @CallId        INT,
		 @Source        nvarchar(max),
		 @Modified      datetime = null,
		 @QuestionOrder INT = null,
		 @ChoiceOrder   INT = null
		AS
		  IF @Modified is null SET @Modified = GETUTCDATE();
		  UPDATE Response
		  SET    ProjectId = @ProjectId,
				 CollectMode = CASE WHEN @CollectMode < 0 THEN CollectMode ELSE @CollectMode END,
				 modifiedby = @UserId,
				 modified = @Modified,
				 RpsContent = @RpsContent,
				 RpsOpened = @RpsOpened,
				 CallId = @CallId,
				 [Source] = @Source,
				 QuestionOrder = @QuestionOrder,
				 ChoiceOrder = @ChoiceOrder
		  WHERE  RpsRespondent = @RpsRespondent
				 AND RpsQuestion = @RpsQuestion
				 AND RpsMatrix = @RpsMatrix
				 AND RpsMention = @RpsMention
				 AND RpsType = @RpsType
		  IF @@ROWCOUNT = 0
		  BEGIN
			INSERT INTO Response
			(RpsRespondent,
			 ProjectId,
			 CollectMode,
			 modifiedby,
			 modified,
			 RpsQuestion,
			 RpsMatrix,
			 RpsMention,
			 RpsContent,
			 RpsOpened,
			 RpsType,
			 CallId,
			 [Source],
			 QuestionOrder,
			 ChoiceOrder)
		 VALUES    (@RpsRespondent,
			 @ProjectId,
			 @CollectMode,
			 @UserId,
			 @Modified,
			 @RpsQuestion,
			 @RpsMatrix,
			 @RpsMention,
			 @RpsContent,
			 @rpsOpened,
			 @rpsType,
			 @CallId,
			 @Source,
			 @QuestionOrder,
			 @ChoiceOrder)
		  END
		'
	END
GO



